//
//  MCSourceListDefines.h
//  MCApplication
//
//  Created by Michael Clark on Tue Jul 27 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef enum _MCSourceListType {
    MCSourceListTypeSystem				= 10,
	MCSourceListTypeSystemRecents       = 20,
	MCSourceListTypeTaskInbox           = 5,
	MCSourceListTypeSync                = 22,
	MCSourceListTypeTouch               = 23,
	MCSourceListTypeApplicationCustom   = 25,
    MCSourceListTypeWatch               = 30,
    MCSourceListTypeSmart               = 40,
    MCSourceListTypeDumb                = 50
} MCSourceListType;


typedef enum _MCSourceListVisibility {
    MCSourceListVisibilityPrivate				= 0,
    MCSourceListVisibilityShared				= 1
} MCSourceListVisibility;



// Notifications
extern NSString*  MCSourceListSelectedNotification;

// This notification is used by other objects which would like to focus the source list
//  stack on given objects.
// There are a few conditions to keep in mind.  The objects should be of the same type, or 
//  at least can be represented by the same source list identifier.
// The source list stack tries to do the least obtrusive thing for the user as possible, i.e.
//  it will try to match the objects in the currently selected source list(s), and if not then
//  it will resort to changing the visible views and adding the objects to the recents special 
//  source list.
extern NSString* MCSourceListShowObjectsNotification;

// MCSourceListEditor posts this notification when a new source list is created
// These keys are populated into the userInfo of the notification
// MCSourceListKey, MCGroupIdentifierKey, MCDocumentKey
extern NSString*  MCSourceListAddedNotification;

// MCSourceListEditor posts this notification when an existing source list is edited
// The keys in the notifications userInfo are: 
// MCSourceListKey, MCGroupIdentifierKey, MCDocumentKey
extern NSString*  MCSourceListEditedNotification;

// The source list pane views post this notification when an existing source list is deleted
// The keys in the notifications userInfo are: 
// MCSourceListKey, MCGroupIdentifierKey, MCDocumentKey
extern NSString*  MCSourceListDeletedNotification;

extern NSString*  MCWatchListUpdatedNotification;

// Posted by the criteria browser when the user has choosen a criteria to add to the qualifier
extern NSString*  MCAddCriteriaNotification; 

// Posted by a DumbList when objects are added to it and removed from it
extern NSString* MCSourceListObjectsAddedNotification;
extern NSString* MCSourceListObjectsRemovedNotification;

// Notification userInfo Keys
extern NSString*  MCSourceListKey;
extern NSString*  MCSourceListsKey;
extern NSString*  MCGroupIdentifierKey;
extern NSString*  MCSelectedObjectsKey;

extern NSString* MCCriteriaKey; // used for query builder stuff

